# integcheck 1.1
# File system integrity checker validator
#########################################################################################
# integcheck.pl 1.1									#
# by Floydman  floydian_99@yahoo.com							#
# Copyright 2003 SecurIT Informatique Inc.  http://securit.iquebec.com			#
# Based on previous work from Harlan Carvey						#
# This program will take the file hash_log.txt as input, and will generate a MD5 and 	#
# SHA1 hashes, and compare it with the ones contained in the file to validate is the	#
# files have changed or not.  Detected changes are reported to the same dest as LogAgent#
#########################################################################################
# Changes in version 1.1 = Combined both components integcheck and hashgen into the same executable
# Slowed down the process so that it doesn't eat up all the resources

use Digest::MD5;
use Digest::SHA1;
use Socket;
use Sys::Hostname;

$argum = $ARGV[0];

my $timer = 0;

if (($argum ne '') && ($argum ne 'hashgen'))
	{print "Integrity Checker 1.1\nusage : \nintegcheck            runs the tool in integrity checking mode \n                      (or generates hashes if not present)\nintegcheck hashgen    forces the generation of hashes\n"; exit;}

@exclude = ('AdminMisc.dll', 'MD5.dll', 'POSIX.dll', 're.dll', 'SHA1.dll', 'AdminMisc.dll', 'AdvNotify.dll', 'API.dll', 'Daemon.dll', 'Event.dll', 'EventLog.dll', 
'Fcntl.dll', 'Hostname.dll', 'IO.dll', 'IPC.dll', 'LanMan.dll', 'MD5.dll', 'p2x560.dll', 'Perms.dll', 'POSIX.dll', 'Process.dll', 're.dll', 'Registry.dll', 'SHA1.dll', 'Socket.dll', 'Win32.dll');

# Creation of machine ID table
@id = getid();

# Creation of config table
@config = getconfig();

if ((-e 'hash_log.txt') && ($argum eq ''))
	{

	# Print header
	print "Integrity Checker 1.1, brought to you by Floydman\n";
	print "Copyright 2003 SecurIT Informatique Inc.\n";
	print "Based on previous work from Harlan Carvey\n";
	print "http://securit.iquebec.com\n";
	print "\nPress CTRL-C to quit\n";

	### Get the conf file instead, and regenerate the hashes
	$config = "hash_conf.txt"; # log file for checksums...this is the file that will be verified by integcheck.exe

	open (CONF, "$config") || die "Could not open config file: $config!\n";
	my @table = ();
	my $index = 0;
	 while (<CONF>) 
	{ 
	  $file = $_;
	  chomp $file;
	  if (-d $file) 
		{
		$file = $file."\\" unless ($file =~ m/\\$/);
		opendir(DIR,$file);
		my @Files = readdir(DIR);
		close(DIR);
		foreach my $File (@Files) 
			{ 	if ($timer > 35) {sleep 1; $timer = 0;} else {$timer++;} ##

				next if (($File eq "..") || ($File eq "."));
				$File = $file.$File;
				if (-f $File)
				{ 			
				$md5 = md5_hash($File);
				$sha1 = sha1_hash($File);
				$table[$index] = "$File,$md5,$sha1\n"; $index ++;
				}
			   elsif (-d $File) {1;}
			}

		}
	  else {
	    if (-e $file) 
		{
if ($timer > 35) {sleep 1; $timer = 0;} else {$timer++;} ##
	      	$md5 = md5_hash($file);
	      	$sha1 = sha1_hash($file);
		$table[$index] = "$file,$md5,$sha1\n"; $index ++;
	    	}
	    else { print "$file does not exist.\n"; }
		}  
  	}
	
	close(CONF);
	
	### Verifying data integrity, need to reload the conf file first and re-generate the hashes
	$log = "hash_log.txt"; print "Verifying data integrity...\n";
	open (LOG,"$log") || die "Could not open log file: $!\n"; 
	@log = <LOG>; close LOG;
	
	
	while ((@table) || (@log))
		{
		 $line1 = $table[0]; $line2 = $log[0];
		 if ($line1 eq $line2) {shift @table; shift @log;}
		 else 	{my ($fl1, $md1, $sh1) = split (/,/, $line1);
			 my ($fl2, $md2, $sh2) = split (/,/, $line2);
			 if (($fl1 eq $fl2) && ($fl1 ne 'hash_log.txt')) {sendoutput ('integrity.log', "Integrity check 	failed for file $fl1.", @config);
					    shift @table; shift @log;}
			 else	{$missing = 1; $newfile = 1;
				 foreach $item (@log)
					{my ($fl, $md, $sh) =  split (/,/,$item);
					 if ($fl eq $fl1) {$newfile = 0;}
					}
				 foreach $item (@table)
					{my ($fl, $md, $sh) =  split (/,/,$item);
					 if ($fl eq $fl2) {$missing = 0;}
					}
				 if ($missing) 
					{foreach $item (@exclude)
						{if ($fl2=~m/$item/i) {$missing = 0;}}
					if ($missing)
					{sendoutput ('integrity.log', "Integrity check failed for missing file $fl2; system file deleted.", @config); shift @log;}}
				 if ($newfile) {sendoutput ('integrity.log', "Integrity check failed; new file $fl1 added to system.", @config); shift @table;}
				}
			}
		}
	print "Done!\n";
	}
else {hashgen();}

######################

sub hashgen
{# Print header
print "Integrity Checker Hash Generator 1.1, brought to you by Floydman\n";
print "Copyright 2003 SecurIT Informatique Inc.\n";
print "Based on previous work from Harlan Carvey\n";
print "http://securit.iquebec.com\n";
print "\nPress CTRL-C to quit\n";


$config = "hash_conf.txt"; # log file for checksums...this is the file that will be verified by integcheck.exe

$log = "hash_log.txt"; 
open (CONF, "$config") || die "Could not open config file: $config!\n";
if (-e $log) { open (LOG,"> $log"); sendoutput ('integrity.log', "Overwriting hash table $log!(Potential abuse!!!)\n",@config);}
else {open (LOG,"> $log") || die "Could not open output file: $log!\n";}

 while (<CONF>) 
{
  $file = $_;
  chomp $file;
  if (-d $file) 
	{
	$file = $file."\\" unless ($file =~ m/\\$/);
	opendir(DIR,$file);
	my @Files = readdir(DIR);
	close(DIR);
	foreach my $File (@Files) 
		{ 	next if (($File eq "..") || ($File eq "."));
			$File = $file.$File;
			if (-f $File)
			{ 			
			$md5 = md5_hash($File);
			$sha1 = sha1_hash($File);
			print LOG "$File,$md5,$sha1\n";
			}
		   elsif (-d $File) {1;}
		}

	}
  else {
    if (-e $file) 
	{
      	$md5 = md5_hash($file);
      	$sha1 = sha1_hash($file);
      	print LOG "$file,$md5,$sha1\n";
    	}
    else { print "$file does not exist.\n"; }
	}  
  }

close(CONF);
close(LOG); 
print "Done!\n";
}

 sub md5_hash {
  my ($file) = @_;
  open (FILE, $file) or die "Can't open '$file': $!\n";
  binmode(FILE);
my  $digest = Digest::MD5->new->addfile(*FILE)->b64digest;
  return $digest;
}

 sub sha1_hash {
  my ($file) = @_;
  open (FILE, $file) or die "Can't open '$file': $!\n";
  binmode(FILE);
my  $digest = Digest::SHA1->new->addfile(*FILE)->b64digest;
  return $digest;
}

#########################################################################################
# procedure getconfig() 								#
# This procedure gets the configuration file config.txt.				#
#########################################################################################
sub getconfig
{
my @configtable;
my @dirtable;
$j = 0;
$numarg = 0;
open(CONFIGFILE,"<config.txt") || die "Can't open config.txt";
$logip = <CONFIGFILE> || die "Can't read  logip from config.txt";
($logip=~m/LOGIP/i) || die "LOGIP entry missing in config.txt";

$loghost = <CONFIGFILE> || die "Can't read loghost from config.txt";
($loghost=~m/LOGHOST/i) || die "LOGHOST entry missing in config.txt";

$loguser = <CONFIGFILE> || die "Can't read loguser from config.txt";
($loguser=~m/LOGUSER/i) || die "LOGUSER entry missing in config.txt";

$logdate = <CONFIGFILE> || die "Can't read logdate from config.txt";
($logdate=~m/LOGDATE/i) || die "LOGDATE entry missing in config.txt";

$logtime = <CONFIGFILE> || die "Can't read logtime from config.txt";
($logtime=~m/LOGTIME/i) || die "LOGTIME entry missing in config.txt";

$showconsole = <CONFIGFILE> || die "Can't showconsole read from config.txt";
($showconsole=~m/SHOWCONSOLE/i) || die "SHOWCONSOLE entry missing in config.txt";

$lp = <CONFIGFILE> || die "Can't read lineprint from config.txt";
($lp=~m/LINEPRINT/i) || die "LINEPRINT entry missing in config.txt";

$lpbuffer = <CONFIGFILE> || die "Can't read lineprint buffer from config.txt";
($lpbuffer=~m/LINEPRINT BUFFER/i) || die "LINEPRINT BUFFER entry missing in config.txt";

while (defined($dir = <CONFIGFILE>))
	{
	 $dirtable[$j]=$dir;
	 $j++;
	}
($j==0) && die "No destination directory specifed in config.txt.";
close (CONFIGFILE) || die "Can't close config.txt";

@configtable = ($logip, $loghost, $loguser, $logdate, $logtime, $showconsole, $lp, $lpbuffer, @dirtable);
@configtable = parse(@configtable);

(($numarg=@configtable)<9) && die "Not enough parameters in config.txt.  Check file for errors.";

# Tranformation of the first 7 lines of configtable to boolean value
$configtable[0]=$configtable[0]=~m/Y/i;
$configtable[1]=$configtable[1]=~m/Y/i;
$configtable[2]=$configtable[2]=~m/Y/i;
$configtable[3]=$configtable[3]=~m/Y/i;
$configtable[4]=$configtable[4]=~m/Y/i;
$configtable[5]=$configtable[5]=~m/Y/i;
$configtable[6]=$configtable[6]=~m/Y/i;

# Get the lineprint buffer
@element=split(/=/, $configtable[7]);
$configtable[7]=$element[1]; ($configtable[7]>=0) || die "LINEPRINT BUFFER entry must be 0 or a positive number in config.txt";
return (@configtable);
}


#########################################################################################
# procedure getid() 									#
# This procedure gets the IP address, the host name and the username of the machine.	#
#########################################################################################

sub getid
{
# Define username, IP address and hostname of the local machine
my $addr = inet_ntoa(scalar(gethostbyname($name)) || 'localhost');
my $host = hostname() || "hostname not defined";
my $login = getlogin || getpwuid($<) || "not logged";
my @id_table = ($addr, $host, $login);
return (@id_table);

}


#########################################################################################
# procedure sendoutput(filename, line, config)						#
# This procedure receives as arguments: the name of the modified file, the last line	#
# of the logfile, and then the config table (LOGIP, LOGHOST, LOGUSER, SHOWCONSOLE, and 	#
# the various destination directories).  The procedure checks the configuration to see	#
# if it has to append any information to the original line or not.  If SHOWCONSOLE in 	#
# enabled, then the line is printed on the screen, if not it simply passes to the next	#
# step which is to forward this line to all mentionned destinations in config.txt.	#
#########################################################################################

sub sendoutput
{ my ($filename, $lines, $logip, $loghost, $loguser, $logdate, $logtime, $showconsole, $lp, $lpbuffer, @dest) = @_;

my $line = '';
my @newlines = split (/\n/,$lines);
foreach $line (@newlines)
 {
 my $newline=""; 

 if ($logip) {$newline=$newline.$id[0].",";}
 if ($loghost) {$newline=$newline.$id[1].",";}
 if ($loguser) {$newline=$newline.$id[2].",";}
 if ($logdate || $logtime) {($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);} 
 if ($logdate) {$newline=$newline.($year+=1900)."/".$mon."/".$mday.",";}
 if ($logtime) {$newline=$newline.$hour.":".$min.":".$sec.",";}

 $newline=$newline.$line."\n";

 if ($showconsole) {print $newline;}

 if (lc($dest[0])ne"null") 
   {
   foreach $destdir (@dest)
      {
       $destination=$destdir.$filename;
       open (DEST, ">>".$destination) || die "Can't open master log file $destination";
       flock (DEST, 2) || die "Can't lock file for writing";
       print DEST $newline || die "Can't write to file";
       close (DEST) || die "Can't close master log file";
      }
   }


 if ($lp) { push @buffer, $newline; $buffer=@buffer;
	    if ($buffer>=$lpbuffer+1) { 
				       open(LINEPRINT,">LPT1") || die "Can't open pipe to LPT1";
				       foreach $line (@buffer){print LINEPRINT $line;}
				       close (LINEPRINT) || die "Can't close pipe to LPT1";
				       @buffer=();
				       } 
           }
 }
}

#########################################################################################
# procedure parse(table_file) 								#
# This procedure cleans the files from non-valid and blank characters that could be	#
# placed in the config files.  The procedure returns the file as a table.		#
#########################################################################################

sub parse
{ my (@table) = @_;

#check for invalid characters in table_file
chomp @table;

foreach $element (@table)
 {
  $element=~s%^\s+%%;
  @char = split (//, $element);

  foreach $char (@char)
    { $char=~s%\\%/%; }
  $element = join ('',@char);
 }

my @tabletemp;
my $x = 0;

foreach $element (@table)
   {
    if ($element ne '') {
	$tabletemp[$x]=$element;
	$x++;}
   }
@table = @tabletemp;
return (@table);
}
